// // // // // // // // // // // // //
//
//	AVLNode.cc
//
//	created April/28/98 by Andreas Warnke
//	modified April/28/98 by Andreas Warnke
//



// // // // // // // // // // // // //
//
//	include
//

#include "AVLNode.h"
#include "AVLTree.h"



// // // // // // // // // // // // //
//
//	Constructors:
//

AVLNode :: AVLNode ( int inKey )
{
	//	Set default values:
	TheKey = inKey;
	TheTree = NULL;
	TheLeft = NULL;
	TheRight = NULL;
	TheBalance = 0;
};



// // // // // // // // // // // // //
//
//	Destructor:
//

AVLNode :: ~AVLNode ()
{
	if ( TheTree != NULL )
		//	This node is in a tree.
		TheTree -> Remove ( this );
};



// // // // // // // // // // // // //
//
//	Set the Key:
//

bool AVLNode :: SetAVLKey ( int inKey )
{
	//	allowed, to change the key?
	if ( TheTree != NULL )
		return false;

	//	set key:
	TheKey = inKey;

	//	ready:
	return true;
};



// // // // // // // // // // // // //
//
//	Get the Key:
//

int AVLNode :: AVLKey () const
{
	return TheKey;
};


	
//
//	The End
//
// // // // // // // // // // // // //